﻿Partial Public Class MainPage
    Inherits PhoneApplicationPage

    Private rotateTransform As New RotateTransform()

    Public Sub New()
        InitializeComponent()
    End Sub


    Private Sub OnLoaded(ByVal sender As Object,
                         ByVal args As RoutedEventArgs) Handles Me.Loaded
        Dim center As New Point(ContentPanel.ActualWidth / 2 - 1,
                                ContentPanel.ActualHeight / 2 - 1)
        Dim radius = Math.Min(center.X, center.Y)

        Dim _polyline As New Polyline()
        _polyline.Stroke = TryCast(Me.Resources("PhoneForegroundBrush"), Brush)
        _polyline.StrokeThickness = 3

        For angle = 0 To 3599.75 Step 0.25
            Dim scaledRadius = radius * angle / 3600
            Dim radians = Math.PI * angle / 180
            Dim x = center.X + scaledRadius * Math.Cos(radians)
            Dim y = center.Y + scaledRadius * Math.Sin(radians)
            _polyline.Points.Add(New Point(x, y))
        Next angle
        ContentPanel.Children.Add(_polyline)

        rotateTransform.CenterX = center.X
        rotateTransform.CenterY = center.Y
        _polyline.RenderTransform = rotateTransform

        AddHandler CompositionTarget.Rendering, AddressOf OnCompositionTargetRendering
    End Sub


    Private Sub OnCompositionTargetRendering(ByVal sender As Object, ByVal args As EventArgs)
        Dim elapsedTime = (TryCast(args, RenderingEventArgs)).RenderingTime
        rotateTransform.Angle = 360 * elapsedTime.TotalSeconds / 3 Mod 360
    End Sub
End Class
